<?php

namespace Devsaadat\ShopGostardeh\Telegram\Classes;

use Devsaadat\ShopGostardeh\Telegram\Enums\ReplyMarkup;
use Devsaadat\ShopGostardeh\Telegram\Enums\Buttons as ButtonType;
use Exception;
use Devsaadat\ShopGostardeh\Gostardeh\GostardehApi;
use lucadevelop\TelegramEntitiesDecoder\EntityDecoder;
use Medoo\Medoo;
use Devsaadat\ShopGostardeh\Helpers\Payment4;
use Http\Client\Common\Plugin\HeaderDefaultsPlugin;
use ZarinPal\Sdk\ClientBuilder;
use ZarinPal\Sdk\Options;
use ZarinPal\Sdk\ZarinPal;
use ZarinPal\Sdk\Endpoint\PaymentGateway\RequestTypes\RequestRequest;

class Message extends CommonMethods
{
    /**
     * @throws Exception
     */
    public function handle(object $update): void
    {
        global $database;
        $message = $update->message;
        $chat_shared = $message->chat_shared;
        $users_shared = $message->users_shared;
        $text = $message->text;
        $caption = $message->caption;
        $message_id = $message->message_id;
        $photo = $message->photo;
        $video = $message->video;
        $voice = $message->voice;
        $audio = $message->audio;
        $sticker = $message->sticker;
        $document = $message->document;
        $forward_from = $message->forward_from;
        $forward_from_chat = $message->forward_from_chat;
        $chat = $message->chat;
        $chat_id = $chat->id;
        $chat_type = $chat->type;
        $from = $message->from;
        $from_id = $from->id;
        $last_name = $from->last_name;
        $first_name = $from->first_name;
        $username = $from->username;
        $this->userid = $from_id;
        $this->chatid = $chat_id;
        $this->messageid = $message_id;
        $reply_to_message = $message->reply_to_message;
        $this->chat_type = $chat_type;
        $this->update = $update;
        $this->username = $username ?? "";
        $this->text = $text ?? "";
        $this->user_name = $first_name .' '. $last_name;
        $now = $time = time();

        #============== reply to user message in support chat
        if($reply_to_message){
            if($reply_to_message->from->id == BOT_ID){
                if(preg_match('/^reply([0-9]+)msg([0-9]+)$/', $reply_to_message->text, $match)){
                    if(in_array($from_id, $this->ADMINS)) {
                        CopyMessage($match[1], $chat_id, $message_id, reply_to_message_id: $match[2]);
                        SendMessage($chat_id, "پیام ارسال شد.", reply_to_message_id: $message_id);
                    } else {
                        SendMessage($chat_id, "⛔️ شما ادمین ربات نیستید.", reply_to_message_id: $message_id);
                    }
                    return;
                }
            }
        }
        //===================== [خاموش بودن ربات] ===============
        elseif(!$this->CONFIG['bot_status'] and !in_array($chat_id,$this->ADMINS) and $chat_type == 'private'){
            SendMessage($chat_id,"🚫 ربات خاموش است.");
            return;
        }
        elseif($chat_type !== 'private' and !in_array($chat_id,$this->ADMINS)) return;
        #============== get user info || insert user in db
        $getuser = $this->getUser();
        if(!$getuser) return;
        $command = $getuser['command'];
        $checkJoin = ($now + 300 < $getuser['last_check_join'] ?: $now) ? $this->checkJoin($from_id) : [];
        //================================ [بلاک] ===============================
        if($getuser['block'] and !in_array($chat_id,$this->ADMINS) and $chat_type == 'private'){
            SendMessage($chat_id,"شما بلاک شده اید");
        }
        //===================== [پاسخ پیام پشتیبانی]=============================
        elseif(preg_match('/^\/start+\s+(answeruser-[0-9]+)/',$text, $match) and in_array($from_id,$this->ADMINS)){
            SendMessage($chat_id,"پیام خود را ارسال کنید:",$this->button(ButtonType::BackAdmin));
            $this->setCommand($match[1]);
        }
        elseif(preg_match('/^answeruser-([0-9]+)/',$command, $match) and in_array($from_id,$this->ADMINS)){
            $this->setCommand();
            CopyMessage($match[1], $chat_id, $message_id);
            SendMessage($chat_id,"پیام شما ارسال شد.",$this->button(ButtonType::AdminPanel),$message_id);
        }
        //============================ [استارت] ====================
        elseif(preg_match('/^\/[Ss][Tt][Aa][Rr][Tt]/',$text, $match) or $text == $this->admin_user_switch_btn and in_array($chat_id,$this->ADMINS)){
            if(count($checkJoin) > 0 and !in_array($from_id,$this->ADMINS)){
                $checkJoin[] = [['text' => "✅ عضو شدم",'callback_data' => "join"]];
                $this->SendMessageByName($chat_id, 'force_join', "⚠️⛔️ جهت ادامه و استفاده از ربات ابتدا باید در کانال(های) زیر عضو شوید
    
پس از عضویت روی دکمه عضو شدم کلیک کنید ✅👇", $this->CreateKeyboard($checkJoin, ReplyMarkup::InlineKeyboard));
            }
            else
            {

                $this->SendMessageByName($chat_id, "start", "سلام خوش آمدید ❤️‍🔥

یک گزینه را انتخاب کنید👇",$this->button(ButtonType::Official));
            }
            $this->setCommand();
        }
        // =========================== [بازگشت] ==================
        elseif($text == $this->main_menu_btn){
            SendMessage($chat_id,"عملیات لغو شد ✅",$this->button(ButtonType::Official));
            $this->setCommand();
        }
        //========================== [جوین اجباری] =======================
        elseif(count($checkJoin) > 0 and !in_array($from_id,$this->ADMINS)){
            $checkJoin[] = [['text' => "✅ عضو شدم",'callback_data' => "join"]];
            $this->SendMessageByName($chat_id,"force_join", "برای استفاده از ربات باید ابتدا عضو کانال (های) زیر شوید.", $this->CreateKeyboard($checkJoin, ReplyMarkup::InlineKeyboard));
        }
        //===================== [راهنما] =======================
        elseif($text == $this->help_btn){
            $this->SendMessageByName($chat_id, "help");
        }
        //========================= [پتشیبانی] ======================
        elseif($text == $this->contact_us_btn){
            if($this->CONFIG['support']) {
                $this->setCommand("support");
                $this->SendMessageByName($chat_id, "support", "پیام خود را ارسال کنید:", $this->button(ButtonType::Back));
            } else {
                SendMessage($chat_id, "❗️ در حال حاضر این امکان فراهم نیست");
            }
        }
        elseif($command == "support"){
            $SUPPORT = $this->SETTING['support_chat'] ?? ADMIN;
            $send = ForwardMessage($SUPPORT,$chat_id,$message_id);
            SendMessage($SUPPORT,"reply{$from_id}msg$message_id",null,$send['result']['message_id']);
            SendMessage($chat_id,"✅ پیام شما دریافت شد.",$this->button(ButtonType::Official),$message_id);
            $this->setCommand();
        }
        //============================= [حساب من] ======================
        elseif($text == $this->my_account_btn){
            $join_time = myJdate(timestamp: $getuser['join_time']);
            $mojodi = number_format($getuser['mojodi']);
            SendMessage($chat_id,"👤 شناسه کاربری: <code>$from_id</code>
📆  زمان عضویت: $join_time

💰 اعتبار فعلی: <b>$mojodi</b> تومان", $this->button(ButtonType::Profile));
        }
        //=========================== [افزایش موجودی ==================
        elseif($text == $this->online_transaction_btn){
            if($this->CONFIG['online_transaction'] and isset($this->SETTING['zarinpal_merchant'])){
                SendMessage($chat_id, "💰 مبلغ مورد نظر را به تومان ارسال کنید:", $this->button(ButtonType::Back));
                $this->setCommand("addBalance");
            }else{
                SendMessage($chat_id,"❗ در حال حاضر امکان شارژ حساب وجود ندارد.", $this->CreateKeyboard($this->addBalanceBtn(), ReplyMarkup::Keyboard));
            }
        }
        elseif($command == "addBalance"){
            if(is_numeric($text = enNumbers($text)) and $text >= 1000 and $text <= 5000000){
                $clientBuilder = new ClientBuilder();
                $clientBuilder->addPlugin(new HeaderDefaultsPlugin([
                    'Accept' => 'application/json',
               ]));
                $options = new Options([
                    'client_builder' => $clientBuilder,
                    'sandbox' => false, // Enable sandbox mode
                    'merchant_id' => $this->SETTING['zarinpal_merchant'],
               ]);
                $zarinpal = new ZarinPal($options);
                $paymentGateway = $zarinpal->paymentGateway();
                $callback_url = 'https://'. $_ENV['DOMAIN'] .'/'. $_ENV['DIRECTORY'] .'/payments/Zarinpal/Callback.php';
                $description = "افزایش اعتبار برای ". $getuser['telegram_name'] ." با شناسه تلگرام ". $from_id;
                $request = new RequestRequest();
                $request->amount = $text;
                $request->description = $description;
                $request->callback_url = $callback_url;
                $request->currency = 'IRT';
                try {
                    $response = $paymentGateway->request($request);
                    $payment_id = $response->authority;
                    $payment_url = $paymentGateway->getRedirectUrl($payment_id); // create full url Payment
                    $this->setCommand();
                    $database->insert(PAYMENTS_TABLE, [
                        'user_id' => $from_id,
                        'amount' => $text,
                        'time' => $time,
                        'payment_id' => $payment_id,
                        'order_id' => RandomString(5),
                        'status' => 'pending',
                        'payment_type' => 'zarinpal'
                   ]);
                    $this->SendMessageByName($chat_id, "payment_guid", null);
                    SendMessage($chat_id,"✅ لینک پرداخت ساخته شد.
			
			جهت افزایش موجودی روی دکمه زیر کلیک کنید.", $this->CreateKeyboard([
                        [['text' => "انتقال به صفحه پرداخت",'url' => $payment_url]]
                   ], ReplyMarkup::InlineKeyboard));
                } catch (Exception $e) {
                    $this->setCommand();
                    SendMessage($chat_id,"خطایی رخ داد. کمی بعد تلاش کنید", $this->CreateKeyboard($this->addBalanceBtn(), ReplyMarkup::Keyboard));
                    error("خطای درگاه زرین پال: " . $e->getMessage());
                }
            }else{
                SendMessage($chat_id,"❌ حداقل مبلغ 1000 و حداکثر 5000000 تومان میباشد.",$this->button(ButtonType::Back));
            }
        }
        elseif($text == $this->payment4_transaction_btn){
            if($this->CONFIG['payment4_transaction'] and isset($this->SETTING['payment4_key'])){
                $this->setCommand("addBalancePayment4");
                SendMessage($chat_id,"مبلغ مورد نظر را به تومان وارد کنید:",$this->button(ButtonType::Back));
            } else SendMessage($chat_id,"در حال حاضر امکان شارژ حساب با ااین درگاه امکان پذیر نمی‌باشد ❗", $this->CreateKeyboard($this->addBalanceBtn(), ReplyMarkup::Keyboard));
        }
        elseif($command == "addBalancePayment4"){
            if(is_numeric($text = enNumbers($text)) and $text >= 1000 and $text <= 5000000){
                $this->setCommand();
                $order_id = RandomString(5);
                try {
                    $nowPayments = new Payment4($this->SETTING['payment4_key']);
                    $result = $nowPayments->createPayment($text, "https://" . $_ENV['DOMAIN'] . "/" . $_ENV['directory'] . "/payments/Payment4/Callback.php", 'IRT', (object)['order_id' => $order_id], "https://" . $_ENV['DOMAIN'] . "/" . $_ENV['DIRECTORY'] . "/payments/Payment4/Webhook.php", (object)['order_id' => $order_id], 'fa');
                    if (isset($result['paymentUid'])) {
                        $database->insert(PAYMENTS_TABLE, [
                            'user_id' => $from_id,
                            'amount' => $text,
                            'time' => $time,
                            'payment_id' => $result['paymentUid'],
                            'order_id' => $order_id,
                            'status' => 'waiting',
                            'payment_type' => 'payment4'
                       ]);
                        $this->SendMessageByName($chat_id, "payment_guid", null);
                        SendMessage($chat_id, "
✅ لینک پرداخت ساخته شد.

<b>پرداخت شما به صورت اتوماتیک تایید و ثبت سیستم خواهد شد و پس از پرداخت دقایقی صبر کنید</b>
جهت انتقال به صفحه پرداخت روی دکمه زیر کلیک کنید:", $this->CreateKeyboard([
                            [['text' => "انتقال به صفحه پرداخت", 'url' => $result['paymentUrl']]],
                       ], ReplyMarkup::InlineKeyboard));
                    } else {
                        SendMessage($chat_id, "❌ خطایی رخ داد کمی بعد تلاش کنید .", $this->CreateKeyboard($this->addBalanceBtn(), ReplyMarkup::Keyboard));
                    }
                } catch (Exception $e){
                    SendMessage($chat_id,"❌ خطایی رخ داد.",$this->CreateKeyboard($this->addBalanceBtn(), ReplyMarkup::Keyboard));
                    SendLog($e->getMessage());
                }
            } else SendMessage($chat_id,"❌ حداقل مبلغ 1000 و حداکثر 5000000 تومان میباشد.",$this->button(ButtonType::Back));
        }
        //===================== [ثبت سفارش] ====================
        elseif($text == $this->new_order){
            if($this->CONFIG['new_order'] and isset($_ENV['GOSTARDEH'])) {
                $this->SendMessageByName($chat_id, 'newOrder-chat', "👈  کانال را با استفاده از دکمه زیر انتخاب کنید:", $this->button(ButtonType::SelectAdsChat));
                $this->setCommand("newOrder-selectChat");
            } else {
                SendMessage($chat_id, "فعلا امکان ثبت سفارش وجود ندارد!", $this->button(ButtonType::Official));
            }
        }
        elseif($command == 'newOrder-selectChat'){
            if($chat_shared){
                $chatid = $chat_shared->chat_id;
                $title = $chat_shared->title;
                $is_group = (bool)$chat_shared->request_id;
            }
            else
            {
                SendMessage($chat_id, "⚠️ خطا!
		
👈 کانال خود را با استفاده از دکمه زیر انتخاب کنید:", $this->button(ButtonType::SelectAdsChat), $message_id);
                return;
            }
            
            if($database->count(ORDERS_TABLE, ['chat_id' => $chatid, 'status' => 'pending']) < 1) {
                $s = SendMessage($chat_id, "کمی صبر کنید ...", $this->button(ButtonType::Back));
                        try {
                            $Gostardeh = new GostardehApi($_ENV['GOSTARDEH']);
                            $inquiry = $Gostardeh->inquiryChannelRate2($chatid);
                            if ($inquiry['ok']) {
                                $price = $inquiry['result']['rate'];
                                $COMMISSION = (($price * ($this->SETTING['COMMISSION'] ?? 0)) / 100) + $inquiry['result']['commission'];
                                $commission_ = number_format($COMMISSION);
                                $price_ = number_format($price);
                                $dt = ['chat_id' => $chatid, 'title' => $title, 'price' => $price, 'commission' => $COMMISSION, 'is_group' => $is_group];
                                DeleteMessage($chat_id, $s['result']['message_id']);
                                SendMessage($chat_id, "🏷 کانال <b>$title</b> ثبت شد.

💰 هزینه هرکا عضو: <b>$price_</b> تومان
➕ کارمزد ربات: $commission_ تومان
			
👈 اگر میخای به ازای هرکا عضو مبلغ بیشتری از $price_ تومان در نظر بگیری، مبلغ مورد نظرت رو بفرست. در غیر این صورت /skip رو بفرست:", $this->button(ButtonType::Back));
                                $this->setCommand("newOrder-cost", $dt);
                            }
                            else if ($inquiry['error_code'] == 101) {
                                DeleteMessage($chat_id, $s['result']['message_id']);
                                SendMessage($chat_id, "⚠️ خطا!
		
👈 ابتدا ربات " . $inquiry['result']['bot_id'] . " را با دسترسی کامل ادمین کانال کنید (تمام تیک هارا فعال کنید)", $this->button(ButtonType::Back));
                            }
                            else{
                                $this->setCommand();
                                DeleteMessage($chat_id, $s['result']['message_id']);
                                SendMessage($chat_id, "خطای سیستمی رخ داد. کمی بعد تلاش کنید", $this->button(ButtonType::Official));
                                SendLog("خطایی در استعلام قیمت رخ داد" . PHP_EOL . $inquiry['description']);
                            }
                        } catch (Exception $e) {
                            DeleteMessage($chat_id, $s['result']['message_id']);
                            SendMessage($chat_id, "خطایی رخ داد! کمی بعد تلاش کنید", $this->button(ButtonType::Official));
                            SendLog("خطایی در حین ثبت سفارش کاربران رخ داد" . PHP_EOL . $e->getMessage());
                            return;
                        }
            } else {
                SendMessage($chat_id, "⚠️ خطا!
		
👈 برای $title یک تبلیغ فعال وجود داشته و امکان ثبت تبلیغ جدید نیست.", $this->button(ButtonType::SelectAdsChat), $message_id);
            }
        }
        elseif($command == 'newOrder-cost'){
            if($text == '/skip' or is_numeric($text = enNumbers($text))){
                $dt = $this->user_data();
                if($text == '/skip') $text = $dt['price'];
                if($text >= $dt['price']) {
                    $dt['price'] = $text;
                    $final_per_1000 = $dt['price'] + $dt['commission'];
                    $canRequest = ($getuser['mojodi'] / $final_per_1000) * 1000;
                    $canRequest = ceil($canRequest);
                    $canRequest_ = number_format($canRequest);
                    SendMessage($chat_id, "
<blockquote>🔰 حداکثر تعداد عضوی که میتوانید درخواست دهید: $canRequest_ (با توجه به موجودی)</blockquote>
    
👈 تعداد عضو درخواستی را با عدد انگلیسی وارد کنید:", $this->button(ButtonType::Back));
                    $this->setCommand("newOrder-quantity", $dt);
                } else {
                    $price_ = number_format($dt['price']);
                    SendMessage($chat_id, "⚠️ خطا!

مبلغ پیشنهادی شما باید بیشتر از نرخ مصوب به ازای هرکا ($price_ تومان) باشد. در غیراین صورت دستور /skip رو بفرست", $this->button(ButtonType::Back), $message_id);
                }
            }
            else
            {
                SendMessage($chat_id, "⚠️ خطا!
		
👈 یا نرخ مورد نظرت به ازای هرکا ممبر رو با عدد برام بفرست، یا /skip رو بفرست با همون نرخ مصوب بریم ادامه ثبت سفارش:", $this->button(ButtonType::Back), $message_id);
            }
        }
        elseif($command == 'newOrder-quantity'){
            if(is_numeric($text = enNumbers($text)) and $text >= 0){
                $MIN_ORDER = $this->SETTING['MIN_ORDER'] ?: 500;
                $MAX_ORDER = $this->SETTING['MAX_ORDER'] ?: 10000;
                if($text >= $MIN_ORDER and $text <= $MAX_ORDER){
                    $dt = $this->user_data();
                    $amount = ($text / 1000) * ( $dt['price'] + $dt['commission'] );
                    $amount_ = number_format($amount);
                    if($getuser['mojodi'] >= $amount){
                        $dt['quantity']=$text;
                        $dt['amount']=$amount;
                        SendMessage($chat_id, "💰 هزینه این سفارش: <b>$amount_</b> تومان

🎁 اگر قصد دارید برای نفراتی که بیشترین اد را برای این تبلیغ بزند هدیه ای در نظر بگیرید مبلغ مورد نظر و تعداد نفرات را مانند نمونه وارد کنید:

مثال:
<b>100000</b> <code>(مبلغ به تومان)</code>
<b>1</b> <code>(تعداد نفرات برتر)</code>

در غیر این صورت /skip را ارسال کنید", $this->button(ButtonType::Back));
                        $this->setCommand("newOrder-gift", $dt);
                    } else {
                        $mojodi_ = number_format($getuser['mojodi']);
                        SendMessage($chat_id, "⚠️ خطا! اعتبار حساب شما کافی نیست.

💰 اعتبار شما: $mojodi_ تومان
💰هزینه سفارش: <b>$amount_</b> تومان", $this->button(ButtonType::Back), $message_id);
                    }
                }
                else
                {
                    SendMessage($chat_id, "⚠️ خطا!

حداقل سفارش $MIN_ORDER و حداکثر $MAX_ORDER عضو میباشد.", $this->button(ButtonType::Back), $message_id);
                }
            }
            else
            {
                SendMessage($chat_id, "⚠️ خطا!

تعداد عضو درخواستی را با عدد انگلیسی وارد کنید.", $this->button(ButtonType::Back), $message_id);
            }
        }
        elseif($command == 'newOrder-gift'){
            $text == enNumbers($text);
            if(preg_match('/([0-9]+)\n?([0-9]*)/', $text, $match) or $text == '/skip'){
                $dt = $this->user_data();
                $amount = $dt['amount'];
                if($text == '/skip'){
                    $gift = 0;
                    $gift_users = 1;
                } else {
                    $gift = (int) $match[1];
                    $gift_users = $match[2] ? round($match[2]) : 1;
                }
                if($gift >= 0 and $gift_users >= 1) {
                    if ($amount + $gift <= $getuser['mojodi']) {
                        $dt['gift'] = $gift;
                        $dt['gift_users'] = $gift_users;
                        $gift_ = number_format($gift);
                        $quantity = number_format($dt['quantity']);
                        if($gift > 0){
                            $gift_details = "\n🎁 هدیه: $gift_ تومان ";
                            $gift_details .= "( برای " . numberToWords($gift_users) . " نفر برتر)";
                            $amount += $gift;
                        } else $gift_details = "";
                        $amount_ = number_format($amount);
                        SendMessage($chat_id, "اطلاعات سفارش شما:

💬 عنوان کانال: <a href='{$dt['link']}'>{$dt['title']}</a>
👥 عضو درخواستی: $quantity {$gift_details}
💰 هزینه سفارش: <b>$amount_</b> تومان

👈 تایید میکنید؟", $this->button(ButtonType::Confirm));
                        $this->setCommand("newOrder-confirm", $dt);
                    } else {
                        $mojodi_ = number_format($getuser['mojodi'] - $amount);
                        SendMessage($chat_id, "⚠️ خطا! اعتبار حساب شما کافی نیست.

💰 اعتبار شما: $mojodi_  تومان (با احتساب هزینه این سفارش)", $this->button(ButtonType::Back), $message_id);
                    }
                } else {
                    SendMessage($chat_id, "⚠️ خطا!

فرمت وارد شده صحیح نیست.", $this->button(ButtonType::Back), $message_id);
                }
            } else {
                SendMessage($chat_id, "⚠️ خطا!

مبلغ را هدیه مورد نظر را با عدد وارد کنید!

در غیر این صورت /skip را ارسال کنید.", $this->button(ButtonType::Back), $message_id);
            }
        }
        elseif($command == 'newOrder-confirm'){
            $dt = $this->user_data();
            $title = $dt['title'];
            $quantity = $dt['quantity'];
            $price = $dt['price'];
            $gift = $dt['gift'];
            $gift_users = $dt['gift_users'];
            $commission = $dt['commission'];
            $chatid = $dt['chat_id'];
            $amount = ($quantity / 1000) * ($price + $commission) + $gift;
            $amount_ = number_format($amount);
            $price_ = number_format($price);
            $gift_ = number_format($gift);
            $commission_bot = ($quantity / 1000) * $commission;
            $commission_bot_ = number_format($commission_bot);
            if ($text == $this->confirm_btn) {
                $this->setCommand();
                SendMessage($chat_id, "⏳ کمی صبر کنید ...", $this->button(ButtonType::Remove), $message_id);
                    try {
                        $Gostardeh = new GostardehApi($_ENV['GOSTARDEH']);
                        $order = $Gostardeh->newOrder($chatid, $quantity, $price, $gift, $gift_users, 'https://'. $_ENV['DOMAIN'] . '/' . $_ENV['DIRECTORY'] .'/src/Api/updateOrdersStatus.php');
                    } catch (Exception $e) {
                        SendMessage($chat_id, "خطایی رخ داد! کمی بعد تلاش کنید");
                        SendLog("خطایی در حین ثبت سفارش کاربران رخ داد" . PHP_EOL . $e->getMessage());
                        return;
                    }
                    if ($order['ok']) {
                        $final_order_cost = $order['result']['cost'];
                        $final_order_cost_ = number_format($final_order_cost);
                        $order_id = $order['result']['id'];
                        $database->insert(ORDERS_TABLE, [
                            'user_id' => $from_id,
                            'order_id' => $order_id,
                            'chat_id' => $chatid,
                            'title' => $title,
                            'quantity' => $quantity,
                            'price' => $price + $commission,
                            'final_commission' => $commission_bot,
                            'final_price' => $amount,
                            'api_price' => $final_order_cost,
                            'gift' => $gift,
                            'gift_users' => $gift_users,
                            'time' => $time,
                            'update_time' => $time
                       ]);
                        $orderid = $database->id();
                        $database->insert(COMMISSION_TABLE, [
                            'user_id' => $from_id,
                            'amount' => $commission_bot,
                            'time' => $now,
                            'chatid' => $orderid
                       ]);
                        $database->update(USERS_TABLE, [
                            'mojodi[-]' => $amount
                       ], ['user_id' => $from_id]);
                        SendMessage($chat_id, "✅ تبلیغ شما ثبت شد
                        
                        شماره سفارش: <code>$orderid</code>
                        هزینه سفارش: <b>$amount_</b> تومان", $this->button(ButtonType::Official));
                        $user_name = $this->user_name;
                        $before_balance = $getuser['mojodi'];
                        $after_balance = number_format($before_balance - $amount);
                        $before_balance = number_format($before_balance);
                        $last_transaction = $database->get(PAYMENTS_TABLE, ['amount', 'payment_type'], ['user_id' => $from_id, 'ORDER' => ['id' => 'DESC'], 'LIMIT' => 1]);
                        $last_transaction_amount = $last_transaction ? number_format($last_transaction['amount']) . "  ($last_transaction[payment_type])" : "تراکنشی نداشته";
                        SendMessage($this->SETTING['orders_chat'] ?? ADMIN, "✅ یک سفارش جدید ثبت شد!
👤 کاربر: <code>$from_id</code>
🗣 نام کاربر: $user_name
🆔 یوزرنیم: @$username
شماره سفارش داخلی: <code>$orderid</code>
شماره سفارش وبسرویس: <code>$order_id</code>
➖➖➖➖➖➖➖➖➖
💰 <b>هزینه ها</b>
هزینه سفارش: $amount_ تومان
کمیسیون شما: $commission_bot_ تومان
هزینه ثبت در وبسرویس: $final_order_cost_ تومان
➖➖➖➖➖➖➖➖➖
💰 <b>موجودی</b>
- قبل سفارش: $before_balance
- بعد سفارش: $after_balance

💸 <b>مبلغ آخرین تراکنش:</b> $last_transaction_amount
");
                    }
                    elseif($order['error_code'] == 101){
                        SendMessage($chat_id, "⚠️ ابتدا باید ربات {$order['result']['bot_id']} را در کانال یا گروه مورد نظر با دسترسی کامل ادمین کنید.", $this->button(ButtonType::Official));
                    }
                    elseif($order['error_code'] == 102){
                        SendMessage($chat_id, "⚠️ حداقل سفارش {$order['result']['min']} و حداکثر آن {$order['result']['max']} می باشد.", $this->button(ButtonType::Official));
                    }
                    else {
                        SendMessage($chat_id, "⚠️ خطایی رخ داد! کمی بعد تلاش کنید.", $this->button(ButtonType::Official));
                        SendLog("⚠️ خطایی در ثبت تبلیغ رخ داد!
            
<code>{$order['description']}</code>");
                        error("خطای ثبت تبلیغ :". $order['description']);
                        if($order['error_code'] == 103){
                            SendMessage(ADMIN, "🚨 هشدار کسری موجودی وبسرویس

یکی از کاربران درخواست ثبت سفارشی به ارزش {$order['result']['order_amount']} تومان را داشته اما موجودی شما {$order['result']['balance']} می باشد!");
                        }
                    }
            } else {
                if($gift > 0){
                    $gift_details = "\n هدیه:$gift_ تومان ";
                    $gift_details .= "( برای " . numberToWords((int) $gift_users) . " نفر برتر)";
                } else $gift_details = "";
                SendMessage($chat_id,"- موضوع: $title
- تعداد ممبر: $quantity
- قیمت به ازای 1000 عدد: $price_ تومان $gift_details
- مبلغ کل: $amount_ تومان		

✅ آیا تایید میکنید؟", $this->button(ButtonType::Confirm));
            }
        }
        //==================== [پیگیری سفارشات] =====================
        elseif($text == $this->peygiri_order){
            $countAll = $database->count(ORDERS_TABLE, ['user_id' => $from_id]);
            if($countAll > 0 ){
                $s = SendMessage($chat_id, "در حال استعلام\nکمی صبر کنید ...", reply_to_message_id: $message_id);
                $btn = [];
                $next =  5;
                $count_pages = ceil($countAll / 5);
                $this_page = 1;
                $txt = "🗒 لیست سفارش های شما: (صفحه $this_page از $count_pages)\n";
                $getList = $database->select(ORDERS_TABLE, '*', [
                    "user_id" => $from_id,
                    "ORDER" => ["time" => "DESC"],
                    "LIMIT" => 5
               ]);
                try{
                    $Gostardeh = new GostardehApi($_ENV['GOSTARDEH']);
                    $getOrderByIds = $Gostardeh->getOrderByIds(array_column($getList, 'order_id'));
                } catch (Exception $e){
                    editMessageText($chat_id, "خطایی رخ داد. کمی بعد تلاش کنید", $s['result']['message_id']);
                    SendLog("خطایی در حین استعلام سفارشات کاربر رخ داد" . PHP_EOL . $e->getMessage());
                    return;
                }
                if($getOrderByIds['ok']) {
                    foreach ($getList as $fetch) {
                        $order = $getOrderByIds['result'][$fetch['order_id']];
                        $id = $fetch['id'];
                        $title = $fetch['title'];
                        $price_ = number_format($fetch['price']);
                        $quantity_ = number_format($fetch['quantity']);
                        $joined_ = number_format($order['joined_count']);
                        $remaining = number_format($order['remaining']);
                        $final_price_ = number_format($fetch['final_price']);
                        $date = myJdate(timestamp: $fetch['time']);
                        $status = $fetch['status'];
                        $status_ = str_replace(['pending', 'done', 'partial'], ['در حال انجام', 'تکمیل شده', 'ناقص شده'], $status);
                        $txt .= "\n🔅 شناسه: <code>$id</code>
🏷 موضوع: $title
🫂 تعداد ممبر درخواستی: $quantity_
🫂 تعداد عضو شده: $joined_
🫂 تعداد باقی مانده: $remaining
💰 قیمت هر 1000 عدد: $price_ تومان
💰 هزینه سفارش: $final_price_ تومان
📆 زمان ثبت: $date
وضعیت: <b>$status_</b>";
                        if ($order['cancel']) $txt .= PHP_EOL . "❌ لغو تبلیغ /cancel_ads_$id";
                        $txt .= PHP_EOL . "〰️〰️〰️〰️〰️〰️〰️〰️〰️〰️";
                    }
                    if ($countAll > $next) {
                        $btn[] = [['text' => $this->next_page_btn, 'callback_data' => "myOrders-$next"]];
                    }
                    editMessageText($chat_id, $txt, $s['result']['message_id'], $this->CreateKeyboard($btn, ReplyMarkup::InlineKeyboard));
                } else {
                    editMessageText($chat_id, "خطایی رخ داد. کمی بعد تلاش کنید", $s['result']['message_id']);
                    SendLog("خطایی در حین استعلام سفارشات کاربر رخ داد" . PHP_EOL .$getOrderByIds['description']);
                }
            }
            else
            {
                SendMessage($chat_id,"شما تا کنون هیچ سفارشی ثبت نکرده اید!", $this->button(ButtonType::Official), $message_id);
            }
        }
        //-------- لغو تبلیغ
        elseif(preg_match('/^\/cancel_ads_([0-9]+)$/', $text, $match)){
            $id = $match[1];
            SendMessage($chat_id, "آیا از حذف تبلیغ شماره <b>$id</b> اطمینان دارید؟", json_encode(['inline_keyboard' => [
                [['text' => "بله 💯 درصد حذف کن ❌", 'callback_data' => "cancelAds_$id"]],
                [['text' => "پشیمون شدم", 'callback_data' => "del"]]
           ]]), $message_id);
        }
        //========================================== پنل ادمین ===========================
        elseif(preg_match('/^\/[Pp][Aa][Nn][Ee][Ll]+$/',$text) || $text == $this->admin_panel_btn and in_array($from_id,$this->ADMINS)){
            $this->setCommand();
            SendMessage($chat_id,"به پنل مدیریت خوش آمدید.", $this->button(ButtonType::AdminPanel));
        }
        elseif($text == "➡️ بازگشت" and in_array($from_id,$this->ADMINS)){
            $this->setCommand();
            SendMessage($chat_id,"به منوی اصلی برگشتید.", $this->button(ButtonType::AdminPanel));
        }
        elseif($text == $this->back_admin_btn and in_array($from_id,$this->ADMINS)){
            if(str_starts_with($command, 'setting')){
                SendMessage($chat_id,"یک گزینه انتخاب نمایید.", $this->button(ButtonType::Setting));
            }
            else{
                SendMessage($chat_id,"♻️ به منوی اصلی برگشتید",$this->button(ButtonType::AdminPanel));
            }
            $this->setCommand();
        }
        //========================== [تغییر متن ها] ======================
        elseif($text == "📝 تنظیم پیام ها" and in_array($chat_id,$this->ADMINS)){
            SendMessage($chat_id,"👇🏼 یک مورد را برای تغییر انتخاب کن", $this->button(ButtonType::Messages));
        }
        elseif(preg_match('/^addmsg-(.*)/',$command, $match) and in_array($chat_id,$this->ADMINS)){
            $txt = $match[1];
            try {
                if($text != null and isset($message->entities)){
                    $decoder = new EntityDecoder();
                    $text = $decoder->decode($message);
                }
                else if($caption != null and isset($message->caption_entities)){
                    $decoder = new EntityDecoder();
                    $caption = $decoder->decode($message);
                }
            } catch (Exception $e) {
                SendLog("خطایی مربوط به EntityDecoder رخ داد: ". $e->getMessage());
                SendMessage($chat_id, "خطایی رخ داد!");
                return;
            }
            if($text) $values = ['type' => 'text', 'text' => $text];
            elseif($photo) $values = ['type' => 'photo', 'caption' => $caption, 'file_id' => $photo[count($photo) - 1]->file_id];
            elseif($video) $values = ['type' => 'video', 'caption' => $caption, 'file_id' => $video->file_id];
            elseif($sticker) $values = ['type' => 'sticker', 'caption' => $caption, 'file_id' => $sticker->file_id];
            elseif($audio) $values = ['type' => 'audio', 'caption' => $caption, 'file_id' => $audio->file_id];
            elseif($voice) $values = ['type' => 'voice', 'caption' => $caption, 'file_id' => $voice->file_id];
            elseif($document) $values = ['type' => 'document', 'caption' => $caption, 'file_id' => $document->file_id];
            else{
                SendMessage($chat_id,"❗️ این پیام پشتیبانی نمی شود.", $this->button(ButtonType::BackAdmin),$message_id);
                return;
            }
            $values['name'] = $txt;
            $database->insert(MESSAGES_TABLE, $values);
            $this->setCommand();
            SendMessage($chat_id,"✅ پیام جدید ذخیره شد.",$this->button(ButtonType::AdminPanel), $message_id);
        }
        //========================== [ادمین ها] ============================
        elseif($text == '👥 ادمین ها' and in_array($chat_id,$this->ADMINS)){
            SendMessage($chat_id,"👈🏽 به بخش #ادمین_ها خوش آمدید",$this->CreateKeyboard($this->admins_list(), ReplyMarkup::InlineKeyboard));
        }
        elseif($command == 'addAdmin' and in_array($chat_id,$this->ADMINS)){
            if($users_shared) $text = $users_shared->user_ids[0];
            $text = enNumbers($text);
            if($this->getUser($text, ['user_id'])){
                if(!in_array($text, $this->ADMINS) and $text != $from_id){
                    $searchUser = $this->getUser($text, ['telegram_name']);
                    $getUser = $searchUser;
                    $name = $getUser['telegram_name'];
                    $database->insert(ADMINS_TABLE, [
                        'user_id' => $text,
                        'name' => $name
                   ]);
                    SendMessage($chat_id,"✅ ادمین «<a href='tg://user?id=$text'>$name</a>» به لیست اضافه شد",$this->button(ButtonType::AdminPanel));
                    $btn = $this->admins_list();
                    SendMessage($chat_id,"👈🏽 به بخش #ادمین_ها خوش آمدید",$this->CreateKeyboard($btn, ReplyMarkup::InlineKeyboard));
                    $this->setCommand();
                    SendMessage($text, "شما ادمین ربات شدید.
                    /start");
                }else SendMessage($chat_id,"⚠️ این کاربر از قبل ادمین بود",$this->button(ButtonType::SelectUser), $message_id);
            }else SendMessage($chat_id,"⚠️ این کاربر عضو ربات نیست",$this->button(ButtonType::SelectUser), $message_id);
        }
        //======================== [تنظیمات] =============================
        elseif($text == '⚙️ تنظیمات' and in_array($chat_id,$this->ADMINS)){
            
            SendMessage($chat_id,"✅ = فعال است
❌ غیر فعال است

👇🏼 برای تغییر هر یک کلیک کنید", $this->CreateKeyboard($this->botConfigBtn($this->CONFIG), ReplyMarkup::InlineKeyboard));
        }
        elseif($text == "🛠 سایر تنظیمات" || $text == $this->back_admin_btn and in_array($from_id,$this->ADMINS)){
            
            SendMessage($chat_id,"یک گزینه انتخاب کنید.", $this->button(ButtonType::Setting));
            $this->setCommand();
        }
        elseif($text == '📣 تنظیم کانال گزارشات' || $text == '📣 تنظیم گروه پشتیبانی' || $text == '📣 تنظیم کانال سفارشات' and in_array($chat_id,$this->ADMINS)){
            SendMessage($chat_id,"👈 چت مورد نظر را با استفاده از دکمه های زیر انتخاب نمایید.",$this->button(ButtonType::SelectChatSetting));
            $choose = match($text){
                '📣 تنظیم گروه پشتیبانی' => 'support_chat',
                '📣 تنظیم کانال گزارشات' => 'report_chat',
                '📣 تنظیم کانال سفارشات' => 'orders_chat'
            };
            $this->setCommand("setting-setChat_$choose");
        }
        elseif(preg_match('/^setting-setChat_(.+)/', $command, $match) and in_array($chat_id,$this->ADMINS)){
            if($chat_shared){
                $chatid = $chat_shared->chat_id;
                $getChatMember = getChatMember(BOT_ID, $chatid);
                if($getChatMember['result']['status'] == 'administrator'){
                    SendMessage($chat_id,"✅ تنظیم شد",$this->button(ButtonType::Setting));
                    $this->setCommand();
                    $this->setSetting($match[1], $chatid);
                }else{
                    SendMessage($chat_id,"❗️ ربات ادمین چت مورد نظر نیست",$this->button(ButtonType::SelectChatSetting));
                }
            }else{
                SendMessage($chat_id,"👈 چت مورد نظر را با استفاده از دکمه های زیر انتخاب نمایید.",$this->button(ButtonType::SelectChatSetting));
            }
        }
        // کارمزد سفارش
        elseif($text == "💰 تنظیم کمیسیون سفارش" and in_array($from_id,$this->ADMINS)){
            $txt = $this->SETTING['COMMISSION'] ?: 10;
            SendMessage($chat_id,"کارمزد سفارش چند درصد باشد؟
		
		☑️ مقدار قبلی:
		$txt %",$this->button(ButtonType::BackMenuAdmin));
            $this->setCommand("setting-commission");
        }
        elseif($command == "setting-commission" and in_array($from_id,$this->ADMINS)){
            if(is_numeric($text = enNumbers($text)) and $text >= 0 and $text <= 100){
                SendMessage($chat_id,"✅ مقدار جدید تنظیم شد",$this->button(ButtonType::Setting));
                $this->setCommand();
                $this->setSetting('COMMISSION', $text);
            }else{
                SendMessage($chat_id,"با اعداد و مابین 0-100 وارد کنید:");
            }
        }
        // حداکثر و حداقل سفارش
        elseif($text == "🫂 تنظیم حداقل سفارش" and in_array($from_id,$this->ADMINS)){
            $txt = $this->SETTING['MIN_ORDER'] ?: 100;
            SendMessage($chat_id,"حداقل تعداد سفارش چند تا باشد؟
		
		☑️ مقدار قبلی:
		$txt ",$this->button(ButtonType::BackMenuAdmin));
            $this->setCommand("setting-MIN_ORDER");
        }
        elseif($command == "setting-MIN_ORDER" and in_array($from_id,$this->ADMINS)){
            if(is_numeric($text = enNumbers($text)) and $text > 0){
                if(!isset($this->SETTING['MAX_ORDER']) OR $text < $this->SETTING['MAX_ORDER']) {
                    SendMessage($chat_id, "✅ مقدار جدید تنظیم شد", $this->button(ButtonType::Setting));
                    $this->setCommand();
                    $this->setSetting('MIN_ORDER', $text);
                } else {
                    SendMessage($chat_id, "حداقل سفارش باید از مقدار حداکثر آن کمتر باشد!");
                }
            }else{
                SendMessage($chat_id,"با اعداد و حداقل ۱ وارد کنید:");
            }
        }
        elseif($text == "🫂 تنظیم حداکثر سفارش" and in_array($from_id,$this->ADMINS)){
            $txt = $this->SETTING['MAX_ORDER'] ?: 100000;
            SendMessage($chat_id,"حداکثر تعداد سفارش چند تا باشد؟
		
		☑️ مقدار قبلی:
		$txt ",$this->button(ButtonType::BackMenuAdmin));
            $this->setCommand("setting-MAX_ORDER");
        }
        elseif($command == "setting-MAX_ORDER" and in_array($from_id,$this->ADMINS)){
            if(is_numeric($text = enNumbers($text)) and $text > 0){
                if(!isset($this->SETTING['MIN_ORDER']) OR $text > $this->SETTING['MIN_ORDER']) {
                    SendMessage($chat_id, "✅ مقدار جدید تنظیم شد", $this->button(ButtonType::Setting));
                    $this->setCommand();
                    $this->setSetting('MAX_ORDER', $text);
                } else {
                    SendMessage($chat_id, "حداکثر سفارش باید از حداقل آن بیشتر باشد");
                }
            }else{
                SendMessage($chat_id,"با اعداد و حداقل ۱ وارد کنید:");
            }
        }
        // حذف بن ها
        elseif($text == "🗑 حذف بن لیست" and in_array($from_id,$this->ADMINS)){
            SendMessage($chat_id, "آیا از آنبلاک کردن تمامی بلاک شده ها اطمینان دارید؟", $this->button(ButtonType::ConfirmAdminSetting));
            $this->setCommand("setting-dropBans");
        }
        elseif($command == "setting-dropBans" and in_array($from_id,$this->ADMINS)){
            if($text == $this->confirm_btn) {
                SendMessage($chat_id, "❎ حذف شد
    
    یک گزینه انتخاب کنید.", $this->button(ButtonType::Setting));
                $database->update(USERS_TABLE, ['block' => 0]);
                $this->setCommand();
            } else {
                SendMessage($chat_id, "آیا از آنبلاک کردن تمامی بلاک شده ها اطمینان دارید؟", $this->button(ButtonType::ConfirmAdminSetting));
            }
        }
        // تنظیم مرچنت کد درگاه پرداخت
        elseif($text == '🔑 تنطیم مرچنت کد زرین پال' and in_array($from_id, $this->ADMINS)){
            $zarinpal_merchant = $this->SETTING['zarinpal_merchant'] ? "<code>". $this->SETTING['zarinpal_merchant'] ."</code>" : "تنظیم نشده است";
            SendMessage($chat_id, "مرچنت کد فعلی: $zarinpal_merchant
            
            مقدار جدید را ارسال کنید :", $this->button(ButtonType::BackMenuAdmin), $message_id);
            $this->setCommand("setting-ZarinpalMerchant");
        }
        elseif($command == 'setting-ZarinpalMerchant' and in_array($from_id, $this->ADMINS)){
            if(preg_match('/^[a-z0-9_-]{36}/i', $text)){
                $this->setSetting('zarinpal_merchant', $text);
                $this->setCommand();
                SendMessage($chat_id, "✅ مقدار جدید ذخیره شد.", $this->button(ButtonType::Setting), $message_id);
            } else {
                SendMessage($chat_id, "⚠️ مقدار وارد شده صحیح نیست.", $this->button(ButtonType::BackMenuAdmin), $message_id);
            }
        }
        elseif($text == '🔑 تنطیم کلید Api گسترده' and in_array($from_id, $this->ADMINS)){
            $gostardeh_key = $_ENV['GOSTARDEH'] ? "<code>". $_ENV['GOSTARDEH'] ."</code>" : "تنظیم نشده است";
            SendMessage($chat_id, " کلید فعلی: $gostardeh_key
            
            کلید جدید را ارسال کنید :", $this->button(ButtonType::BackMenuAdmin), $message_id);
            $this->setCommand("setting-GostardehKey");
        }
        elseif($command == 'setting-GostardehKey' and in_array($from_id, $this->ADMINS)){
            if(preg_match('/^[a-z0-9]{32}/i', $text)){
                setEnvValue('GOSTARDEH', $text, ENV_FILE_DIR);
                $this->setCommand();
                SendMessage($chat_id, "✅ کلید جدید ذخیره شد.", $this->button(ButtonType::Setting), $message_id);
            } else {
                SendMessage($chat_id, "⚠️ کلید وارد شده معتبر نیست.", $this->button(ButtonType::BackMenuAdmin), $message_id);
            }
        }
        //---------------
        elseif($text == '🔑 تنطیم کلید Payment4' and in_array($from_id, $this->ADMINS)){
            
            $payment4_key = $this->SETTING['payment4_key'] ? "<code>". $this->SETTING['payment4_key'] ."</code>" : "تنظیم نشده است";
            SendMessage($chat_id, " کلید فعلی:$payment4_key
            
            مقدار جدید را ارسال کنید :", $this->button(ButtonType::BackMenuAdmin), $message_id);
            $this->setCommand("setting-Payments4Key");
        }
        elseif($command == 'setting-Payments4Key' and in_array($from_id, $this->ADMINS)){
            if(preg_match('/^[a-z0-9-_]+$/i', $text)){
                $this->setSetting('payment4_key', $text);
                $this->setCommand();
                SendMessage($chat_id, "✅ مقدار جدید ذخیره شد.", $this->button(ButtonType::Setting), $message_id);
            } else {
                SendMessage($chat_id, "⚠️ مقدار وارد شده صحیح نیست.", $this->button(ButtonType::BackMenuAdmin), $message_id);
            }
        }
        //==================== ارسال همگانی =================================
        elseif($text == '📨 ارسال همگانی' and in_array($from_id,$this->ADMINS)){
            SendMessage($chat_id,"📬 پیام خود ( متنی، تصویری، فایلی یا فرواردی ) را به ربات ارسال کنید:",$this->button(ButtonType::BackAdmin));
            $this->setCommand("sendToAllMessage");
        }
        elseif($command == 'sendToAllMessage' and in_array($from_id,$this->ADMINS)){
            $type = $forward_from ? 'forward' : ($forward_from_chat ? 'forward' : 'copy');
            $dt = [
                'type' => $type,
                'admin' => $from_id,
                'start_time' => $time,
                'message_id' => $message_id,
                'from_chat_id' => $chat_id
           ];
            SendMessage($chat_id,"ارسال را تایید میکنید؟", $this->button(ButtonType::ConfirmAdmin));
            $this->setCommand("sendToAllConfirm", $dt);
        }
        elseif($command == 'sendToAllConfirm' and in_array($from_id,$this->ADMINS)){
            if($text == $this->confirm_btn){
                $database->insert(SEND_TABLE, $this->user_data());
                $id = $database->id();
                SendMessage($chat_id,"✅ پیام شما با شناسه $id در صف ارسال قرار گرفت. تا پایان ارسال این پیام را از پیوی ربات حذف نکنید.", $this->button(ButtonType::AdminPanel));
                $this->setCommand(clear_data: true);
            } else {
                SendMessage($chat_id,"ارسال را تایید میکنید؟", $this->button(ButtonType::ConfirmAdmin));
            }
        }
        elseif($text == "📈 پیگیری ارسال" and in_array($from_id,$this->ADMINS)){
            SendMessage($chat_id,"کد پیگیری ارسال را وارد کنید:",$this->button(ButtonType::BackAdmin));
            $this->setCommand("sendTracking");
        }
        elseif($command == "sendTracking" and in_array($from_id,$this->ADMINS)){
            if(is_numeric($text)){
                $file = $database->get(SEND_TABLE, '*', ['id' => $text]);
                if($file){
                    SendMessage($chat_id,"در حال استعلام...",$this->button(ButtonType::AdminPanel));
                    $this->setCommand();
                    $start_time = $file['start_time'];
                    $end_time = $file['end_time'];
                    $sent = $file['sent'];
                    $failed = $file['failed'];
                    $status = $file['status'];
                    $status_ = str_replace(['sending','done', 'pending'],["در حال ارسال...","ارسال شده", "در صف ارسال"],$status);
                    $start_time = myJdate(timestamp: $start_time);
                    if(!$end_time) $end_time = "ثبت نشده"; else $end_time = myJdate(timestamp: $end_time);
                    $members = $sent + $failed;
                    SendMessage($chat_id,"♻️ وضعیت ارسال با کد پیگیری <code>$text</code> به شرح زیر است:", $this->CreateKeyboard([
                        [['text' => $status_,'callback_data' => "0"],['text' => "♻️ وضعیت فعلی:",'callback_data' => "0"]],
                        [['text' => $members,'callback_data' => "0"],['text' => "👥 تعداد کل ارسال:",'callback_data' => "0"]],
                        [['text' => $sent,'callback_data' => "0"],['text' => "✅ ارسال موفق:",'callback_data' => "0"]],
                        [['text' => $failed,'callback_data' => "0"],['text' => "❌ ارسال ناموفق:",'callback_data' => "0"]],
                        [['text' => $start_time,'callback_data' => "0"],['text' => "⏰ زمان ثبت:",'callback_data' => "0"]],
                        [['text' => $end_time,'callback_data' => "0"],['text' => "⏰ زمان پایان:",'callback_data' => "0"]],
                   ], ReplyMarkup::InlineKeyboard));
                }else{
                    SendMessage($chat_id,"ارسال یافت نشد!",$this->button(ButtonType::BackAdmin));
                }
            }else{
                SendMessage($chat_id,"کد ارسال اشتباه است!",$this->button(ButtonType::BackAdmin));
            }
        }
        //====================== [آمار ربات] =============================
        elseif($text == "📊 آمار ربات" and in_array($from_id,$this->ADMINS)){
            $thisMonth = jmktime( 0 , 0 , 0 , myJdate('m') , 1 , myJdate('Y')); // ابتدای سال
            $dayOfWeek = myJdate('w'); // روز هفته جاری (۰ برای شنبه تا ۶ برای جمعه)
            $thisWeekStart = jmktime(0, 0, 0, myJdate('m'), myJdate('d') - $dayOfWeek, myJdate('Y'));
            $allUsers = $database->count(USERS_TABLE);
            $this_hour_users = $database->count(USERS_TABLE, ['join_time[>]' => strtotime("-1 hour")]);
            $this_24_users = $database->count(USERS_TABLE, ['join_time[>]' => strtotime("-24 hour")]);
            $this_7_days_users = $database->count(USERS_TABLE, ['join_time[>]' => $thisWeekStart]);
            $this_month_users = $database->count(USERS_TABLE, ['join_time[>]' => $thisMonth]);
            $blocked_users = $database->count(USERS_TABLE, ['block' => true]);
            $admins = $database->count(ADMINS_TABLE);
            $activeUsers = $database->get(SEND_TABLE, 'sent', ['ORDER' => ['id' => 'DESC'], 'LIMIT' => 1]) ?: "نامشخص";

            $commission = $database->get(COMMISSION_TABLE, [
                "allCommission" => Medoo::raw('SUM(`amount`)'),
                "todayCommission" => Medoo::raw('SUM(CASE WHEN `time` >= UNIX_TIMESTAMP(CURDATE()) THEN `amount` ELSE 0 END)'),
                "weekCommission" => Medoo::raw('SUM(CASE WHEN `time` >= :weekStart THEN `amount` ELSE 0 END)', [
                    ':weekStart' => $thisWeekStart
               ]),
                "monthCommission" => Medoo::raw('SUM(CASE WHEN `time` >= :monthStart THEN `amount` ELSE 0 END)', [
                    ':monthStart' => $thisMonth
               ])
           ]);

            $orders = $database->get(ORDERS_TABLE, [
                'allOrders' => Medoo::raw("(SELECT COUNT(*) FROM ".ORDERS_TABLE.")"),
                'doneOrders' => Medoo::raw("(SELECT COUNT(*) FROM ".ORDERS_TABLE." WHERE status = 'done')"),
                'pendingOrders' => Medoo::raw("(SELECT COUNT(*) FROM ".ORDERS_TABLE." WHERE status = 'pending')"),
                'partialOrders' => Medoo::raw("(SELECT COUNT(*) FROM ".ORDERS_TABLE." WHERE status = 'partial')"),
                'allDoneMembers' => Medoo::raw("(SELECT SUM(`quantity`) FROM ".ORDERS_TABLE." WHERE status = 'done')"),
           ]);

            $allCommission = number_format($commission['allCommission'] ?: 0);
            $todayCommission = number_format($commission['todayCommission'] ?: 0);
            $weekCommission = number_format($commission['weekCommission'] ?: 0);
            $monthCommission = number_format($commission['monthCommission'] ?: 0);

            $allOrders = number_format($orders['allOrders'] ?? 0);
            $doneOrders = number_format($orders['doneOrders'] ?? 0);
            $pendingOrders = number_format($orders['doneOrders'] ?? 0);
            $partialOrders = number_format($orders['partialOrders'] ?? 0);
            $allDoneMembers = number_format($orders['allDoneMembers'] ?? 0);

            SendMessage($chat_id,"
👥 تعداد اعضا: $allUsers
🕒 تعداد کاربران ساعت گذشته: $this_hour_users
☪️ تعداد کاربران 24 ساعت گذشته: $this_24_users
7️⃣ تعداد کاربران این هفته: $this_7_days_users
🌛 تعداد کاربران این ماه: $this_month_users
💠 کاربران فعال: $activeUsers

🔘 تعداد کل سفارشات: $allOrders
🔋 تعداد سفارشات تکمیل شده: $doneOrders
🪫 تعداد سفارشات در حال تکمیل: $pendingOrders
⚠️ تعداد سفارشات ناقص و  لغو شده: $partialOrders
🫂 تعداد کل عضو زده شده: $allDoneMembers

💸 درآمد شما از کمیسیون ها
- کل: $allCommission تومان
- امروز: $todayCommission تومان
- این هفته: $weekCommission تومان
- این ماه: $monthCommission تومان

.",json_encode(['inline_keyboard' => [
                [['text' => "$blocked_users",'callback_data' => "0"],['text' => "❗️ کاربران بن شده:",'callback_data' => "0"]],
                [['text' => "$admins",'callback_data' => "0"],['text' => "👨🏻‍💻 تعداد ادمین ها:",'callback_data' => "0"]],
           ]]));
        }
        //========================= [] ===========================
        elseif($text == "🔍 اطلاعات کاربر" and in_array($from_id,$this->ADMINS)){
            SendMessage($chat_id,"شناسه عددی کاربر را ارسال کنید:",$this->button(ButtonType::SelectUser));
            $this->setCommand("searchUser");
        }
        elseif($command == "searchUser" and in_array($from_id,$this->ADMINS)){
            if($users_shared) $text = $users_shared->user_ids[0];
            if(is_numeric($text = enNumbers($text))){
                $search = $this->getUser($text);
                if($search){
                    SendMessage($chat_id, "کمی صبر کنید ... ", $this->button(ButtonType::AdminPanel));
                    $this->setCommand();
                    $join_time = myJdate(timestamp: $search['join_time']);
                    $mojodi = number_format($search['mojodi']);
                    SendMessage($chat_id,"- زمان عضویت: $join_time
            - موجودی فعلی: $mojodi تومان", $this->CreateKeyboard($this->userBtn($search), ReplyMarkup::InlineKeyboard));
                }else SendMessage($chat_id,"کاربر یافت نشد!",$this->button(ButtonType::BackAdmin));
            }else SendMessage($chat_id,"شناسه را با اعداد لاین وارد کنید!",$this->button(ButtonType::BackAdmin));
        }
        elseif(preg_match('/^userMojodi-([0-9]+)/',$command, $match) and in_array($from_id,$this->ADMINS)){
            if(is_numeric($text = enNumbers($text))){
                $user_id = $match[1];
                $getUser = $this->getUser($user_id, ['mojodi']);
                $userBalance = $getUser['mojodi'];
                $userBalance_ = number_format($userBalance);
                $userBalance += (int) $text;
                if($userBalance < 0){
                    SendMessage($chat_id, "انقدر کسر نمیشه. موجودی فعلی این کاربر: $userBalance_", reply_to_message_id: $message_id);
                    return;
                }
                $database->update(USERS_TABLE, ['mojodi' => $userBalance], ['user_id' => $user_id]);
                $userBalance = number_format($userBalance);
                SendMessage($user_id,"💸 موجودی شما توسط ادمین به $userBalance تومان تغییر کرد.");
                SendMessage($chat_id,"✅ ثبت شد.",$this->button(ButtonType::AdminPanel));
                $this->setCommand();
            }else{
                SendMessage($chat_id,"با عدد وارد کنید!");
            }
        }
        elseif (preg_match('/^userMessage-([0-9]+)/', $command, $match) and in_array($chat_id, $this->ADMINS)) {
            $user_id = $match[1];
            CopyMessage($user_id, $chat_id, $message_id);
            SendMessage($chat_id, "✅ پیام شما ارسال شد.", $this->CreateKeyboard([
                [['text' => $this->back_admin_btn, 'callback_data' => "searchUser-$user_id"]]
           ], ReplyMarkup::InlineKeyboard));
            $this->setCommand();
        }
        //=================================== [جوین اجباری] =========================
        elseif($text == "🔐 جوین اجباری" and in_array($chat_id, $this->ADMINS)){
            SendMessage($chat_id, "وارد بخش عضویت اجباری شدید. یک گزینه را انتخاب کنید:", $this->CreateKeyboard($this->force_join_channels(), ReplyMarkup::InlineKeyboard));
        }
        elseif($command == 'channels-addNew' and in_array($from_id,$this->ADMINS)){
            if($chat_shared) $chatid = $chat_shared->chat_id;
            elseif($forward_from_chat) $chatid = $forward_from_chat->id;
            elseif(preg_match('/^-[0-9]+$/',$text)) $chatid = $text;
            else{
                SendMessage($chat_id,"👈 ابتدا ربات را ادمین کانال یا گروه مورد نظر کرده و سپس یکی از روش های زیر را انجام دهید.
1. ایدی عددی کانال یا گروه را ارسال کنید
2. یک پیام از کانال مورد نظر فروارد کنید.
3. کانال یا گروه مورد نظر را با استفاده از دکمه های زیر انتخاب نمایید.", $this->button(ButtonType::SelectChat), $message_id);
                return;
            }
            $getChatMember = getChatMember(BOT_ID, $chatid);
            if($getChatMember['ok'] and $getChatMember['result']['status'] == 'administrator' and $getChatMember['result']['can_invite_users'] and $getChatMember['result']['can_manage_chat']){
                if($database->count(CHANNELS_TABLE, ['chat_id' => $chatid]) < 1){
                    $title = getChat($chatid)['result']['title'];
                    $link = createChatInviteLink($chatid)['result']['invite_link'];
                    $database->insert(CHANNELS_TABLE, [
                        'chat_id' => $chatid,
                        'link' => $link,
                        'title' => $title,
                   ]);
                    $this->setCommand();
                    SendMessage($chat_id, "✅  قفل جدید با نام « $title » اضافه شد", $this->button(ButtonType::AdminPanel));
                    SendMessage($chat_id, "👈🏽 به بخش #کانال_ها (اسپانسری) خوش آمدید", $this->CreateKeyboard($this->force_join_channels(), ReplyMarkup::InlineKeyboard));
                } else SendMessage($chat_id," این کانال/گروه قبلا اضافه شده است!",$this->button(ButtonType::SelectChat));
            } else SendMessage($chat_id,"ابتدا ربات را در کانال ادمین کرده سپس پیام را فروارد کنید!",$this->button(ButtonType::SelectChat));
        }
        elseif(preg_match('/^etchn-([0-9]+)/',$command, $match) and in_array($from_id,$this->ADMINS)){
            $btn[] = [['text' => "🔄 بازگشت",'callback_data' => 'channels']];
            SendMessage($chat_id,"✅ عنوان جدید تنظیم شد",$this->CreateKeyboard($btn, ReplyMarkup::InlineKeyboard));
            $database->update(CHANNELS_TABLE, ['title' => $text], ['id' => $match[1]]);
            $this->setCommand();
        }
        //=================== [] =======================
        elseif($text == '💰 موجودی وبسرویس' and in_array($from_id,$this->ADMINS)){
            $s = SendMessage($chat_id, "در حال استعلام ...");
            try {
                $Gostardeh = new GostardehApi($_ENV['GOSTARDEH']);
                $getBalance = $Gostardeh->getBalance();
                if($getBalance['ok']){
                    $balance = number_format($getBalance['result']['balance']);
                    editMessageText($chat_id, "موجودی شما: $balance تومان می باشد", $s['result']['message_id']);
                } else {
                    editMessageText($chat_id,"خطایی رخ داد." . PHP_EOL . $getBalance['description'], $s['result']['message_id']);
                }
            } catch (Exception $e) {
                editMessageText($chat_id, "خطایی رخ داد! کمی بعد تلاش کنید", $s['result']['message_id']);
                SendLog("خطایی در حین ثبت استعلام موجودی وبسرویس رخ داد" . PHP_EOL . $e->getMessage());
                return;
            }
        }
        elseif ($text == 'ارتباط با برنامه نویس ربات'){
            SendMessage($chat_id, "برای ارتباط با برنامه نویس <a href='t.me/devsaadat'>اینجا</a> کلیک کنید.");
        }
    }
}