<?php

namespace Devsaadat\ShopGostardeh\Telegram\Classes;

use Devsaadat\ShopGostardeh\Telegram\Enums\Buttons as ButtonType;
use Devsaadat\ShopGostardeh\Telegram\Enums\ReplyMarkup;

trait Buttons
{
    protected string $add_btn = '➕ افزودن جدید';
    protected string $back_admin_btn = '⬅️ قبلی';
    protected string $main_menu_admin_btn = '➡️ بازگشت';
    protected string $yes_btn = 'بله';
    protected string $no_btn = 'خیر';
    protected string $confirm_btn = '✅ تایید و ثبت';
    protected string $next_page_btn = 'صفحه بعد ➡️';
    protected string $back_page_btn = '⬅️ صفحه قبل';
    protected string $my_account_btn = '👤 حساب کاربری';
    protected string $help_btn = '📚 راهنما';
    protected string $contact_us_btn = '📞 پشتیبانی';
    protected string $admin_panel_btn = '⚙️ پنل مدیریت';
    protected string $main_menu_btn = 'بازگشت 🔙';
    protected string $admin_user_switch_btn = '▫️ پنل کاربر';
    protected string $peygiri_order = '📊 پیگیری سفارشات';
    protected string $new_order = '🛒 ثبت سفارش جدید';
    protected string $add_balance_btn = '💰 افزایش موجودی';
    protected string $online_transaction_btn = '💵 شارژ با درگاه زرین پال';
    protected string $payment4_transaction_btn = '💷 شارژ با درگاه ارزی Payment4';
    protected string $my_transactions_btn = '🏧 سوابق تراکنش های من';
    protected string $select_user_btn = '👤 انتخاب کاربر';
    protected string $select_group_btn = '🔰 انتخاب گروه';
    protected string $select_channel_btn = '🔰 انتخاب کانال';

    protected function button(ButtonType $type): string
    {
        $button = match ($type) {

            ButtonType::Remove => [],

            ButtonType::Official => [
                [
                    ['text' => $this->peygiri_order],
                    ['text' => $this->new_order]
                ],
                [
                    ['text' => $this->contact_us_btn],
                    ['text' => $this->help_btn],
                    ['text' => $this->my_account_btn]
                ],
                ((in_array($this->userid, $this->ADMINS)) ? [['text' => $this->admin_panel_btn]] : [])
            ],

            ButtonType::Back => [
                [
                    ['text' => $this->main_menu_btn]
                ]
            ],

            ButtonType::Profile => [
                [['text' => $this->add_balance_btn, 'callback_data' => "addBalance"]],
                [['text' => $this->my_transactions_btn, 'callback_data' => "mytransactions-0"]],
            ],

            ButtonType::Confirm => [
                [['text' => $this->confirm_btn]],
                [['text' => $this->main_menu_btn]]
            ],

            ButtonType::AdminPanel => [
                [['text' => $this->admin_user_switch_btn]],
                [['text' => "🔐 جوین اجباری"],['text' => "📊 آمار ربات"]],
                [['text' => "📈 پیگیری ارسال"],['text' => "📨 ارسال همگانی"]],
                [['text' => "⚙️ تنظیمات"],['text' => "👥 ادمین ها"]],
                [['text' => "🔍 اطلاعات کاربر"],['text' => "📝 تنظیم پیام ها"]],
                [['text' => "🛠 سایر تنظیمات"], ['text' => "💰 موجودی وبسرویس"]],
                [['text' => "ارتباط با برنامه نویس ربات"]]
            ],

            ButtonType::SelectUser => [
                [
                    [
                        'text' => $this->select_user_btn,
                        'request_user' => [
                            'request_id' => time(),
                            'user_is_bot' => false,
                            'max_quantity' => 1
                        ]
                    ]
                ],
                [['text' => $this->main_menu_admin_btn]],
            ],

            ButtonType::SelectChat => [
                [
                    [
                        'text' => $this->select_group_btn,
                        'request_chat' => [
                            'request_id' => time() + 1,
                            'chat_is_channel' => false,
                            'request_title' => true
                        ]
                    ],
                    [
                        'text' => $this->select_channel_btn,
                        'request_chat' => [
                            'request_id' => time(),
                            'chat_is_channel' => true,
                            'request_title' => true
                        ]
                    ]
                ],
                [['text' => $this->main_menu_admin_btn]],
            ],

            ButtonType::SelectChatSetting => [
                [
                    [
                        'text' => $this->select_group_btn,
                        'request_chat' => [
                            'request_id' => time() + 1,
                            'chat_is_channel' => false,
                            'request_title' => true
                        ]
                    ],
                    [
                        'text' => $this->select_channel_btn,
                        'request_chat' => [
                            'request_id' => time(),
                            'chat_is_channel' => true,
                            'request_title' => true
                        ]
                    ]
                ],
                [['text' => $this->back_admin_btn]],
            ],

            ButtonType::SelectChannel => [
                [
                    ['text' => $this->select_channel_btn, 'request_chat' =>
                        [
                            'request_id' => time(),
                            'chat_is_channel' => true,
                            'request_title' => true,
                        ]
                    ]
                ],
                [['text' => $this->main_menu_admin_btn]],
            ],

            ButtonType::SelectAdsChat => [
                [
                    [
                        'text' => $this->select_group_btn,
                        'request_chat' => [
                            'request_id' => 1,
                            'chat_is_channel' => false,
                            'request_title' => true,
                        ]
                    ],
                    [
                        'text' => $this->select_channel_btn,
                        'request_chat' => [
                            'request_id' => 0,
                            'chat_is_channel' => true,
                            'request_title' => true,
                        ]
                    ]
                ],
                [['text' => $this->main_menu_btn]],
            ],

            ButtonType::ConfirmAdmin => [
                [['text' => $this->confirm_btn]],
                [['text' => $this->main_menu_admin_btn]]
            ],

            ButtonType::ConfirmAdminSetting => [
                [['text' => $this->confirm_btn]],
                [['text' => $this->back_admin_btn]]
            ],

            ButtonType::Messages => [
                [
                    ['text' => "بازگشت", 'callback_data' => "editText-start"],
                    ['text' => "استارت", 'callback_data' => "editText-start"]],
                [
                    ['text' => "عضویت اجباری", 'callback_data' => "editText-force_join"],
                    ['text' => "خاموش بودن ربات", 'callback_data' => "editText-bot_off"]],
                [
                    ['text' => "بلاک بودن", 'callback_data' => "editText-user_block"],
                    ['text' =>  "خوش آمدگویی*", 'callback_data' => "editText-welcome"],
                ],
                [
                    ['text' => "پشتیبانی", 'callback_data' => "editText-support"],
                    ['text' => "راهنمای پرداخت آنلاین", 'callback_data' => "editText-payment_guid"],
                ],
                [
                    ['text' => "راهنما", 'callback_data' => "editText-help"],
                    ['text' => "ثبت سفارش جدید", 'callback_data' => "editText-newOrder-chat"],
                ],

            ],

            ButtonType::YesNoAdmin => [
                [['text' => $this->no_btn],['text' => $this->yes_btn]],
                [['text' => $this->main_menu_admin_btn]]
            ],

            ButtonType::BackAdmin => [
                [['text' => $this->main_menu_admin_btn]]
            ],

            ButtonType::BackMenuAdmin => [
                [
                    ['text' => $this->main_menu_admin_btn],
                    ['text' => $this->back_admin_btn]
                ]
            ],

            ButtonType::Setting => [
                [['text' => "📣 تنظیم کانال سفارشات"]],
                [['text' => "📣 تنظیم کانال گزارشات"], ['text' => "📣 تنظیم گروه پشتیبانی"]],
                [['text' => "🫂 تنظیم حداقل سفارش"], ['text' => "🫂 تنظیم حداکثر سفارش"]],
                [['text' => "🔑 تنطیم مرچنت کد زرین پال"], ['text' => "💰 تنظیم کمیسیون سفارش"]],
                [['text' => "🗑 حذف بن لیست"], ['text' => "🔑 تنطیم کلید Payment4"]],
                [['text' => "🔑 تنطیم کلید Api گسترده"]],
                [['text' => $this->back_admin_btn]]
            ],

        };

        return $this->CreateKeyboard($button, (isset($button[0][0]['callback_data'])) ? ReplyMarkup::InlineKeyboard : ReplyMarkup::Keyboard, false);
    }
}