<?php

const ERROR_LOGS_FILE_DIR = __DIR__ . "/../Storage/logs/updateOrdersStatus.log";
ini_set('error_log', ERROR_LOGS_FILE_DIR);
header('Content-Type: application/json; charset=utf-8');
error_reporting(E_ALL & ~E_NOTICE & ~E_WARNING);
date_default_timezone_set('Asia/Tehran');

// فقط از HTTPS مجاز باشد
if (empty($_SERVER['HTTPS']) || $_SERVER['HTTPS'] === 'off') {
    http_response_code(403);
    echo json_encode(['ok' => false, 'description' => 'Https required']);
    exit;
}


require_once __DIR__ . "/../../vendor/autoload.php";
$dotenv = Dotenv\Dotenv::createImmutable(__DIR__ .'/../../');
$dotenv->load();

define("API_KEY", $_ENV['API_KEY']);
define("LOG_CHAT", $_ENV['ADMIN']);

// خواندن ورودی JSON
$input = json_decode(file_get_contents('php://input'), true);

if(isset($input['order_id']) and isset($input['status'])){
    http_response_code(200);
    $database = db_connect();

    $order = $database->get("orders_tbl", ['user_id', 'id', 'title', 'quantity'], ['order_id' => $input['order_id']]);

    if($order){
        $quantity = number_format($order['quantity']);
        $joined = number_format($input['joined']);
        if($input['status'] == 'done') {
            SendMessage($order['user_id'], "✅ سفارش ممبر شما به شماره {$order['id']} با موفقیت تکمیل شد.

📢 کانال : [ {$order['title']} ]

👥 تعداد ممبر درخواستی: $quantity نفر

📊 تعداد ممبر نهایی: $joined نفر

💫 از اعتماد و همراهی شما صمیمانه سپاسگزاریم.

به امید همکاری‌های بیشتر و موفقیت روز افزون شما 🌟");
        } else {
            SendMessage($order['user_id'], "🔔 وضعیت سفارش شما به شماره <code>{$order['id']}</code> به <b>ناقص</b> تغییر یافت.

📢 کانال : [{$order['title']}]

👥 تعداد ممبر درخواستی: $quantity نفر

📊 تعداد ممبر نهایی: $joined نفر

💫 از اعتماد و همراهی شما صمیمانه سپاسگزاریم.

به امید همکاری‌های بیشتر و موفقیت روزافزون شما 🌟");
        }
        $database->update("orders_tbl", ['status' => $input['status'], 'joined' => $input['joined']], ['id' => $order['id']]);
    }

} else {
    http_response_code(400);
    echo json_encode(['ok' => false, 'description' => 'order_id or status is missing']);
}