<?php
ini_set("log_errors", 1);
ini_set("error_log", __DIR__ . "/../../src/Storage/logs/zarinpal.log");

if(!isset($_GET['Status']) or !isset($_GET['Authority'])) die("Bad Request");

error_reporting(E_ALL & ~E_NOTICE & ~E_WARNING & ~E_DEPRECATED);
date_default_timezone_set('Asia/Tehran');
require_once __DIR__ ."/../../vendor/autoload.php";
$dotenv = Dotenv\Dotenv::createImmutable(__DIR__ .'/../../');
$dotenv->load();
//=============================================
$database = db_connect();
$Authority = $_GET['Authority'];
$Status = $_GET['Status'];

use Zarinpal\Zarinpal;
use Zarinpal\Drivers\Soap;

$payment = $database->get("payments_tbl", ['user_id', 'amount', 'status', 'id', 'order_id'], ['payment_id' => $Authority]);

if($payment){
    $id = $payment['id'];
    $user_id = $payment['user_id'];
    $amount = $payment['amount'];
    $order_id =  $payment['order_id'];
    $amount_ = number_format($amount);
    $date = myJdate();
    $SETTING = json_decode(file_get_contents(__DIR__ . "/../../src/Config/setting.json") , true);
    //---------------------------
    define("API_KEY", $_ENV['API_KEY']);
    define("ADMIN", $_ENV['ADMIN']);
    define("BOT_USERNAME", $_ENV['BOT_USERNAME']);
    define("BOT_ID", $_ENV['BOT_ID']);
    define("LOG_CHAT", ADMIN);
    //---------------------------
    $param = [
        'time' => $date,
        'order_id' => $order_id,
        'amount' => $amount_,
        'bot_url' => 'https://t.me/'. BOT_USERNAME
    ];
    $getuser = $database->get("users_tbl", ['telegram_name', 'username', 'mojodi'], ['user_id' => $user_id]);
    $name = $getuser['telegram_name'];
    $username = $getuser['username'];
    $mojodi = number_format($getuser['mojodi']);
    $new_mojodi = number_format($getuser['mojodi'] + $amount);
    $payments_chat = $SETTING['report_chat'] ?? ADMIN;
    $zarinpal = new Zarinpal($SETTING['zarinpal_merchant'], new soap());
    $response = $zarinpal->verify($Status, $amount, $Authority);
    if($response['Status'] == 'success'){
        $param['description'] = "مبلغ به اعتبار حسابتان اضافه گردید";
        $database->update("payments_tbl", ['status' => 'done'], ['id' => $id]);
        $database->update("users_tbl", ['mojodi[+]' => $amount], ['user_id' => $user_id]);
        SendMessage($user_id, "✅ خرید موفق | پرداخت  شما به مبلغ $amount_ در ربات گسترده آپلودری احمدی با موفیقت انجام شد
     
      اطلاعات جدید حساب 
      ↙️↘️ 
- موجودی قبلی: $mojodi
- موجودی جدید: $new_mojodi");
        SendMessage($payments_chat, "✅ خرید موفق | پرداخت  شما تاریخ/زمان $date در ربات گسترده آپلودری احمدی با موفیقت تایید نهایی شده است.
     
      اطلاعات جدید حساب 
      ↙️↘️ 
- نام :$name
- ایدی : @$username
- شناسه حساب :<code>$user_id</code>

💰 مبلغ پرداختی  :$amount_
🏷 کد پیگیری : <code>$order_id</code>
⏰ زمان : $date

- موجودی قبلی: $mojodi
- موجودی جدید: $new_mojodi");
        redirect('https://'. $_ENV['DOMAIN'] .'/'. $_ENV['DIRECTORY'] .'/payments/result/success.php?'. http_build_query($param));
    }
    else if($response['Status'] == 'canceled'){
        $param['description'] = "پرداخت توسط شما لغو شد";
        $database->update("payments_tbl", ['status' => 'canceled'], ['id' => $id]);
        SendMessage($user_id, "❌ پرداخت ناموفق
در صورت کسر وجه از حساب بانکی تا حداکثر 48 ساعت آینده به حساب شما عودت داده خواهد شد.

🏷 کد پیگیری : <code>$order_id</code>");
        SendMessage($payments_chat, "❌ پرداخت ناموفق

👤 اطلاعات کاربر:
- نام :$name
- یوزرنیم : @$username
- شناسه :<code>$user_id</code>

💰 مبلغ :$amount_
🏷 کد پیگیری : <code>$order_id</code>
⏰ زمان : $date");
        redirect('https://'. $_ENV['DOMAIN'] .'/'. $_ENV['DIRECTORY'] .'/payments/result/unsuccessful.php?'. http_build_query($param));
    }
    else if($response['Status'] == 'error'){
        $param['description'] = "خطایی رخ داد";
        $database->update("payments_tbl", ['status' => 'unsuccessful'], ['id' => $id]);
        SendMessage($user_id, "❌ پرداخت ناموفق
در صورت کسر وجه از حساب بانکی تا حداکثر 48 ساعت آینده به حساب شما عودت داده خواهد شد.

🏷 کد پیگیری : <code>$order_id</code>");
        SendMessage($payments_chat, "❌ پرداخت ناموفق

👤 اطلاعات کاربر:
- نام :$name
- یوزرنیم : @$username
- شناسه :<code>$user_id</code>

💰 مبلغ :$amount_
🏷 کد پیگیری : <code>$order_id</code>
⏰ زمان : $date");
        redirect('https://'. $_ENV['DOMAIN'] .'/'. $_ENV['DIRECTORY'] .'/payments/result/unsuccessful.php?'. http_build_query($param));
    }
    else {
        $param['description'] = "نتیجه نامشخص";
        SendMessage($user_id, "❌ پرداخت ناموفق
در صورت کسر وجه از حساب بانکی تا حداکثر 48 ساعت آینده به حساب شما عودت داده خواهد شد.

🏷 کد پیگیری : <code>$order_id</code>");
        redirect('https://'. $_ENV['DOMAIN'] .'/'. $_ENV['DIRECTORY'] .'/payments/result/unsuccessful.php?'. http_build_query($param));
    }
} else {
    die("Bad Request");
}