<?php

use Devsaadat\ShopGostardeh\Helpers\Payment4;

ini_set("log_errors", 1);
ini_set("error_log", __DIR__ . "/../../src/Storage/logs/payment4.log");
error_reporting(E_ALL & ~E_NOTICE & ~E_WARNING & ~E_DEPRECATED);
date_default_timezone_set('Asia/Tehran');

if(!isset($_GET['order_id']) or !isset($_GET['paymentStatus']) or !isset($_GET['paymentUid'])){
    die("bad request");
}
require_once __DIR__. "/../../vendor/autoload.php";
$dotenv = Dotenv\Dotenv::createImmutable(__DIR__.'/../../');
$dotenv->load();
//---------------------------
$paymentStatus = $_GET['paymentStatus'];
$paymentUid = $_GET['paymentUid'];
$order_id = $_GET['order_id'];
$database = db_connect();

$payment = $database->get("payments_tbl", '*', ['order_id' => $order_id, 'payment_id' => $paymentUid]);

if($payment){
    $id = $payment['id'];
    $user_id = $payment['user_id'];
    $amount = $payment['amount'];
    $amount_ = number_format($amount);
    $date = myJdate();
    $SETTING = json_decode(file_get_contents(__DIR__ . "/../../src/Config/setting.json") , true);
    //---------------------------
    define("API_KEY", $_ENV['API_KEY']);
    define("ADMIN", $_ENV['ADMIN']);
    //---------------------------
    $getuser = $database->get("users_tbl", ['telegram_name', 'username', 'mojodi'], ['user_id' => $user_id]);
    $name = $getuser['telegram_name'];
    $username = $getuser['username'];
    $mojodi = number_format($getuser['mojodi']);
    $new_mojodi = number_format($getuser['mojodi'] + $amount);
    $payments_chat = $SETTING['report_chat'] ?? ADMIN;
    try{
        $payment4 = new Payment4($SETTING['payment4_key']);
        $verify = $payment4->verifyPayment($paymentUid, $amount, 'IRT');
        if($verify['verified']){
            if($verify['paymentStatus'] == 'SUCCESS' or $verify['paymentStatus'] == 'ACCEPTABLE') {
                $database->update("payments_tbl", ['status' => 'done'], ['id' => $id]);
                $database->update("users_tbl", ['mojodi[+]' => $amount], ['user_id' => $user_id]);
                SendMessage($user_id, "✅ پرداخت موفق
💰 مبلغ $amount_ تومان به موجودی حسابتان اضافه شد.

- موجودی قبلی: $mojodi
- موجودی جدید: $new_mojodi");
                SendMessage($payments_chat, "✅ پرداخت موفق #payment4

👤 اطلاعات کاربر:
- نام :$name
- یوزرنیم : @$username
- شناسه :<code>$user_id</code>

💰 مبلغ :$amount_
🏷 کد پیگیری : <code>$order_id</code>
⏰ زمان : $date

- موجودی قبلی: $mojodi
- موجودی جدید: $new_mojodi");
            } elseif($verify['paymentStatus'] == 'MISMATCH'){
                SendMessage($user_id, "❌ پرداخت ناقص
بنظر می رسد پرداخت شما ناقص بوده است در صورتی که وجهی از کیف پول شما کسر شده است با پشتبانی در ارتباط باشید.

🏷 کد پیگیری : <code>$order_id</code>");
            }
        } else {
            SendMessage($user_id, "❌ پرداخت ناموفق
در صورت کسر وجه از حساب بانکی تا حداکثر 48 ساعت آینده به حساب شما عودت داده خواهد شد.

🏷 کد پیگیری : <code>$order_id</code>");
        }
    } catch (Exception $e){
        SendLog("خطایی در بررسی تراکنش Payment4 رخ داد!

کاربر: <code>$user_id</code>
مبلغ: $amount_ تومان
کد پیگیری درگاه: <code>$paymentUid</code>
شرح خطا: " . $e->getMessage());
    }
}

