<?php

use Random\RandomException;

header('Content-Type: application/json; charset=utf-8');

function deleteFolder($path): bool
{
    if ($handle=opendir($path)) {
        while (false!==($file=readdir($handle))) {
            if ($file<>"." AND $file<>"..") {
                if (is_file($path.'/'.$file))  {
                    unlink($path.'/'.$file);
                }
                if (is_dir($path.'/'.$file)) {
                    deleteFolder($path.'/'.$file);
                    rmdir($path.'/'.$file);
                }
            }
        }
        return true;
    }
    else return false;
}

$raw = file_get_contents('php://input');
$data = json_decode($raw, true);
if(!is_array($data)){
    echo json_encode(['success'=>false,'message'=>'داده ورودی معتبر نیست']);
    exit;
}

$botToken = isset($data['botToken']) ? trim($data['botToken']) : '';
$adminId = isset($data['adminId']) ? trim($data['adminId']) : '';
$dbName = isset($data['dbName']) ? trim($data['dbName']) : '';
$apikey = isset($data['apikey']) ? trim($data['apikey']) : '';
$dbUser = isset($data['dbUser']) ? trim($data['dbUser']) : '';
$dbPass = $data['dbPass'] ?? '';

$errors = [];
if($botToken === '') $errors['botToken'] = 'توکن ربات الزامی است.';
else if(!preg_match('/^\d+:[A-Za-z0-9_\-]{20,}$/', $botToken)) $errors['botToken'] = 'فرمت توکن نامعتبر است.';

if($apikey === '') $errors['apikey'] = 'کلید وبسرویس الزامی است.';
else if(!preg_match('/^[A-Za-z0-9]{20,}$/', $apikey)) $errors['apikey'] = 'فرمت کلید وبسرویس نامعتبر است.';

if($adminId === '') $errors['adminId'] = 'آیدی ادمین الزامی است.';
else if(!preg_match('/^\d+$/', $adminId)) $errors['adminId'] = 'آیدی باید فقط شامل اعداد باشد.';

if($dbName === '') $errors['dbName'] = 'نام دیتابیس الزامی است.';
else if(!preg_match('/^[A-Za-z0-9_\-]+$/', $dbName)) $errors['dbName'] = 'نام دیتابیس حاوی کاراکترهای غیرمجاز است.';

if($dbUser === '') $errors['dbUser'] = 'یوزرنیم دیتابیس الزامی است.';
else if(!preg_match('/^[A-Za-z0-9_\-]+$/', $dbUser)) $errors['dbUser'] = 'یوزرنیم دیتابیس حاوی کاراکترهای غیرمجاز است.';

if($dbPass === '') $errors['dbPass'] = 'پسورد دیتابیس الزامی است.';

if(!empty($errors)){
    echo json_encode(['success'=>false,'errors'=>$errors,'message'=>'برخی مقادیر نامعتبر هستند.']);
    exit;
}

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://api.telegram.org/bot" . $botToken . "/getMe");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, []);
$getBot = curl_exec($ch);
$decoded = json_decode($getBot, true);
if(isset($decoded['ok']) && $decoded['ok'] === true){
    $botUsername = $decoded['result']['username'];
    $botId = $decoded['result']['id'];
} else {
    echo json_encode(['success'=>false,'message'=>'توکن ربات معتبر نمی باشد: ' . $decoded['description']]);
    exit;
}

// تلاش برای اتصال به دیتابیس
$dsn = "mysql:host=localhost;dbname={$dbName};charset=utf8mb4";
try{
    $pdo = new PDO($dsn, $dbUser, $dbPass, [PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION, PDO::ATTR_AUTOCOMMIT=>1]);
} catch (PDOException $ex){
    $msg = $ex->getMessage();
    try{
        $pdoTmp = new PDO("mysql:host=localhost;charset=utf8mb4", $dbUser, $dbPass, [PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION]);
        $pdoTmp->exec("CREATE DATABASE IF NOT EXISTS `".addslashes($dbName)."` CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;");
// دوباره وصل شو
        $pdo = new PDO($dsn, $dbUser, $dbPass, [PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION]);
    } catch (PDOException $ex2){
        echo json_encode(['success'=>false,'message'=>'ارتباط با دیتابیس برقرار نشد: '.$ex2->getMessage()]);
        exit;
    }
}

// مسیر فایل SQL (تغییر دهید به نام فایل شما)
$sqlFile = __DIR__ . '/database.sql';
if(file_exists($sqlFile)){
    $sqlContents = file_get_contents($sqlFile);
// بخش‌بندی دستورها با ; (این روش ساده است؛ اگر SQL پیچیده است ممکن است نیاز به parser بهتر باشد)
    $statements = array_filter(array_map('trim', explode(";", $sqlContents)));
    foreach($statements as $stmt){
        if($stmt === '') continue;
        try{
            $pdo->exec($stmt);
        } catch (PDOException $e){
// نگذاریم عملیات کامل متوقف شود؛ خطا را لاگ کنیم
            error_log('SQL import error: '.$e->getMessage());
// ادامه می‌دهیم — این رفتار برای آپدیت که دیتا داریم مناسب‌تر است
        }
    }
}

// نوشتن فایل .env
$host = $_SERVER['HTTP_HOST'] ?? 'your-domain.example';
$uri = $_SERVER['REQUEST_URI'];
$path = dirname($_SERVER['REQUEST_URI'] ?? '');
$path = dirname($path);
$path = ltrim($path, '/');
try {
    $webHook_key = md5(time());
} catch (RandomException $e) {
    echo json_encode(['success'=>false,'message'=>'خطای سیستمی ساخت کلید وبهوک رخ داد: '.$ex2->getMessage()]);
    exit;
}
$env_data = [
    'API_KEY' => $botToken,
    'BOT_USERNAME' => $botUsername,
    'BOT_ID' => $botId,
    'ADMIN' => $adminId,
    'GOSTARDEH' => $apikey,
    'db_name' => $dbName,
    'db_user' => $dbUser,
    'db_password' => $dbPass,
    'DOMAIN' => $host,
    'DIRECTORY' => $path,
    'WEBHOOK_KEY' => $webHook_key,
];
$envFile = __DIR__ . '/../.env';
try{
    $env_file = file_get_contents($envFile);
    foreach($env_data as $key => $value){
        $env_file = preg_replace('/^' . preg_quote($key, '/') . '=.*/m', $key . '=' . $value, $env_file);
    }
    file_put_contents($envFile, $env_file);
} catch (Exception $e){
    echo json_encode(['success'=>false,'message'=>'خطا در نوشتن فایل .env: '.$e->getMessage()]);
    exit;
}

$baseUrl = 'https://' . $host;
$webhookUrl = $baseUrl .'/' . $path .'/bot.php';
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, "https://api.telegram.org/bot" . $botToken . "/setWebhook");
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, ['url' => $webhookUrl, 'secret_token' => $webHook_key]);
$webhookResult = curl_exec($ch);
$webhookOk = false;
if (!curl_error($ch)) {
    $decoded = json_decode($webhookResult, true);
    if(isset($decoded['ok']) && $decoded['ok'] === true) $webhookOk = true;
    else $msgs[] = 'وبهوک تنظیم نشد! ' . $decoded['description'];
}
$msgs = [];
$msgs[] = 'اطلاعات ثبت شد.';
if($webhookOk){
    $msgs[] = 'وبهوک با موفقیت تنظیم شد.';
    deleteFolder(__DIR__);
}

echo json_encode(['success'=>true,'message'=>implode(' ', $msgs)]);
exit;